libPath <- "C:\\temp\\MS2Go\\lib"
suppressWarnings({ dir.create("C:\\temp"); dir.create("C:\\temp\\MS2Go"); dir.create(libPath) })
.libPaths(libPath)
#update.packages(lib.loc=libPath, repos="https://cran.wu.ac.at", ask=FALSE)

if (!require(RSQLite, lib=libPath)) {
	install.packages("RSQLite", repos="https://cran.wu.ac.at", lib=libPath)
	require(RSQLite, lib=libPath)
}
if (!require(mcga, lib=libPath)) {
	install.packages("mcga", repos="https://cran.wu.ac.at", lib=libPath)
	require(mcga, lib=libPath)
}
deInst <- FALSE
if (!require(dendextend, lib=libPath)) {
	install.packages("dendextend", repos="https://cran.wu.ac.at", lib=libPath)
	deInst <- require(dendextend, lib=libPath)
} else {
	deInst <- TRUE
}
if (!require(psych, lib=libPath)) {
	install.packages("psych", repos="https://cran.wu.ac.at", lib=libPath)
	require(psych, lib=libPath)
}

qcPlots <- function(pdResFile, pngFileName, filterName, sampleOrder=c()) {
  vars <- sort(ls(globalenv()))

	try(pdResConn <- dbConnect(SQLite(), pdResFile))
  cat("querying PSMs\n")
  try(system.time(psms <- dbGetQuery(pdResConn, "SELECT * FROM TargetPsms;")))
  cat("querying decoy PSMs\n")
  try(system.time(dPsms <- dbGetQuery(pdResConn, "SELECT * FROM DecoyPsms;")))
  try(pdResViewConn <- dbConnect(SQLite(), gsub(".pdResult", ".pdResultView", pdResFile, fixed=TRUE)))
	try(system.time(filteredPsms <- dbGetQuery(pdResViewConn, paste("SELECT * FROM ", filterName, ";", sep=""))))
	try(psms <- merge(x=psms, y=filteredPsms, by=c("WorkflowID", "PeptideID"), all.y=TRUE))
  # exclude second search hits
  if ("SearchDepth" %in% colnames(psms)) {
    psms <- psms[psms$SearchDepth==1,]
  }
  try(system.time(prots <- dbGetQuery(pdResConn, "SELECT * FROM TargetProteins;")))
  
  if (!c("Annotated.Sequence") %in% colnames(psms)) {
    colnames(psms)[colnames(psms)=="Sequence"] <- "Annotated.Sequence"
  }
  tr <- try({
    if (length(sampleOrder)==0) {
      # make dummy sampleOrder
      sampleOrder <- data.frame(file=sort(unique(psms$SpectrumFileName)), stringsAsFactors=FALSE)
      sampleOrder <- data.frame(sampleOrder, shortName=sampleOrder$file, position=1:nrow(sampleOrder), stringsAsFactors=FALSE)
    }
    else {
      sampleOrder <- data.frame(file=sampleOrder, shortName=names(sampleOrder), position=1:length(sampleOrder), stringsAsFactors=FALSE)
    }
    sampleOrder$position <- as.numeric(sampleOrder$position)
    sampleOrder$file <- as.character(sampleOrder$file)
    sampleOrder <- sampleOrder[order(sampleOrder$position),]
    
    sampleOrder$file <- gsub(".raw", "", sampleOrder$file, fixed=TRUE)
    psms$SpectrumFileName <- gsub(".raw", "", psms$SpectrumFileName, fixed=TRUE)
    psms$SpectrumFileName <- as.factor(psms$SpectrumFileName)
    dPsms$SpectrumFileName <- gsub(".raw", "", dPsms$SpectrumFileName, fixed=TRUE)
    dPsms$SpectrumFileName <- as.factor(dPsms$SpectrumFileName)
    if (mean(psms$SpectrumFileName %in% sampleOrder$file)>0) {
      # # add raw to the SpectrumFile in case the name is different in psms
      # notInPsms <- !(sampleOrder$file %in% unique(psms$SpectrumFileName))
      # sampleOrder$file[notInPsms] <- paste(sampleOrder$file[notInPsms], ".raw", sep="")
      # problem: added .raw even if there was no PSMs, searching for wrong file
      
      # # # if there is more psms with .raw at the end at .raw at the end
      # # fnt <- table(psms$SpectrumFileName)
      # # lapply(1:nrow(sampleOrder), function(soix) { fnt[sampleOrder$file[soix]] })
      psms$SpectrumFileName <- factor(psms$SpectrumFileName, levels(psms$SpectrumFileName)[unlist(lapply(as.character(sampleOrder$file), function(l) { which(levels(psms$SpectrumFileName)==l) }))])
      dPsms$SpectrumFileName <- factor(dPsms$SpectrumFileName, levels(dPsms$SpectrumFileName)[unlist(lapply(as.character(sampleOrder$file), function(l) { which(levels(dPsms$SpectrumFileName)==l) }))])
    }
    psms <- psms[!is.na(psms$SpectrumFileName),]
    dPsms <- dPsms[!is.na(dPsms$SpectrumFileName),]
    
    spectrumInfo <- dbReadTable(pdResConn, "MSnSpectrumInfo")
    spectrumInfo$SpectrumFileName <- gsub(".raw", "", spectrumInfo$SpectrumFileName, fixed=TRUE)
    if (!is.factor(spectrumInfo$SpectrumFileName)) {
      spectrumInfo$SpectrumFileName <- as.factor(spectrumInfo$SpectrumFileName)
    }
    if (mean(spectrumInfo$SpectrumFileName %in% sampleOrder$file)>0) {
      spectrumInfo$SpectrumFileName <- factor(spectrumInfo$SpectrumFileName, levels(spectrumInfo$SpectrumFileName)[unlist(lapply(as.character(sampleOrder$file), function(l) { which(levels(spectrumInfo$SpectrumFileName)==l) }))])
      spectrumInfo <- spectrumInfo[!is.na(spectrumInfo$SpectrumFileName),]
    }
  })
  if (class(tr)=="try-error") {
    cat("something crashed in the preprocessing\n")
  }
    
  
  vars <- sort(ls(globalenv()))
  
  checkCols <- function(reqCols, cols, doPlot=TRUE) {
    ret <- mean(reqCols %in% cols)>0.999
    if (!ret) {
      if (doPlot) {
        plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
        text(1, 0, paste("This plot requires column ", reqCols[!(reqCols %in% cols)]), col="red", cex=2)
      }
    }
    ret
  }

  
  quanResNFoundMsg <- ""
  cat("querying for data of new apQuant version\n")
  tr <- try({
    r <- try(quanRes <- dbGetQuery(pdResConn, "SELECT * FROM aQQuanResults WHERE Confidence>1;"), silent=TRUE)
    if (class(r)=="try-error") {
      cat("querying for data of old apQuant version\n")
      # support for Peakjuggler (old)
      r <- try(quanRes <- dbGetQuery(pdResConn, "SELECT * FROM PjQuanResults WHERE Confidence>1;"), silent=TRUE)
    }
    if (!(class(r)=="try-error")) {
      cat("apQuant data successfully queried\n")
      if ("quanRes" %in% ls()) {
        if (nrow(quanRes)>0) {
          quanCols <- gsub("%", "", gsub("µ", "", gsub("\\.", "", gsub(".raw", "", sampleOrder$file[order(sampleOrder$position)], fixed=TRUE))), fixed=TRUE)
          if (checkCols(c("apQuantAreas"), colnames(quanRes), doPlot=FALSE)) {
            chNames <- dbGetQuery(pdResConn, "SELECT Name FROM DataDistributionBoxes WHERE DataDistributionMapID=(SELECT SpecialValueTypeID FROM DataTypesColumns WHERE DBColumnName='apQuantAreas' AND SpecialValueType='DataDistribution' AND DataTypeID=(SELECT DataTypeID FROM DataTypes WHERE TableName='aQQuanResults')) ORDER BY Position;")[,1]
            #quanCols <- chNames # might be wrong sample order
            if (length(chNames)>0) {
              qrWab <- which(unlist(lapply(quanRes[,"apQuantAreas"], function(x) { length(unlist(x)) }))==(9*length(chNames)))
              if (length(qrWab)>1) {
                cat("found data of new apQuant version\n")
                quanRes <- do.call("rbind", lapply(quanRes[qrWab,"apQuantAreas"], function(d) {
                  d <- unlist(d)
                  unlist(lapply(1:length(chNames), function(chIx) {
                    BytesToDouble(d[1:8+(chIx-1)*9])
                  }))
                } ))
                colnames(quanRes) <- chNames
              }
              else {
                quanResNFoundMsg <- "apQuant: blob size does not fit nr of samples"
              }
            }
            else {
              quanResNFoundMsg <- "apQuant: no sample columns found"
            }
          }
          else {
            colnames(quanRes) <- gsub("raw$", "", colnames(quanRes))
            if (!(sum(quanCols %in% colnames(quanRes))>0)) {
              quanResNFoundMsg <- "apQuant: could not find quantitative information for raw files"
            }
          }
        }
        else {
          quanResNFoundMsg <- "apQuant: no quantitative data found"
        }
      }
      else {
        quanResNFoundMsg <- "apQuant: could not query quantitative data"
      }
    }
    else {
      if (checkCols(c("Abundances"), colnames(psms), doPlot=FALSE)) {
        cat("querying for TMT channels\n")
        chNames <- dbGetQuery(pdResConn, "SELECT Name FROM DataDistributionBoxes WHERE DataDistributionMapID=(SELECT SpecialValueTypeID FROM DataTypesColumns WHERE DBColumnName='Abundances' AND SpecialValueType='DataDistribution' AND DataTypeID=(SELECT DataTypeID FROM DataTypes WHERE TableName='TargetPsms')) ORDER BY Position;")[,1]
        #quanCols <- rev(chNames) # might be wrong sample order
        quanCols <- chNames
        if (length(chNames)>0) {
          psmsWab <- which(unlist(lapply(psms[,"Abundances"], function(x) { length(unlist(x)) }))==(9*length(chNames)))
          if (length(psmsWab)>1) {
            cat("TMT data found\n")
            quanRes <- do.call("rbind", lapply(psms[psmsWab,"Abundances"], function(d) {
              d <- unlist(d)
              unlist(lapply(1:length(chNames), function(chIx) {
                BytesToDouble(d[1:8+(chIx-1)*9])
              }))
            } ))
            colnames(quanRes) <- chNames
          }
          else {
            quanResNFoundMsg <- "TMT: blob size does not fit nr of TMT channels"
          }
        }
        else {
          quanResNFoundMsg <- "TMT: no TMT channels found"
        }
      }
      else {
        quanResNFoundMsg <- "TMT: could not find column Abundances"
      }
    }
    if (!("quanRes" %in% ls())) {
      quanResNFoundMsg <- "no quantitative information found"
    }
    else {
      # remove samples not checked in (/passed on) from MS2Go
      # also does reordering already
      if (mean(sampleOrder$file %in% colnames(quanRes))>0.99) {
        quanRes <- quanRes[,sampleOrder$file,drop=FALSE]
        
        #check if number of names fits to number of columns (apQuant grouping), otherwise skip renaming
        if (ncol(quanRes)==nrow(sampleOrder)) {
          # rename quan columns according to renaming in MS2Go GUI
          # 20200514: double resorting of columns for TMT (Trepte), is it still correct with LFQ? yes, checked on samples no-corr
          #colnames(quanRes)[unlist(lapply(colnames(quan), function(cn) { which(colnames(quanRes)==cn) }))] <- sampleOrder$shortName
          colnames(quanRes) <- sampleOrder$shortName
          quanCols <- rev(sampleOrder$shortName)
        }
        else {
          cat("!number of samples in MS2Go does not fit number of quantified samples!\n-> plotting raw files\n")
          quanCols <- colnames(quanRes)
        }
      }
      else {
        cat("ERROR: sample names don't fit, continuing without reordered/renamed samples\n")
        quanCols <- rev(colnames(quanRes))
      }
      quanCols <- rev(quanCols)
    }
  })

  if (class(tr)=="try-error") {
    cat("something crashed in the preprocessing pt2\n")
  }
  
  cat("querying for apQuant feature distF\n")
  aQfRet <- try(aQfs <- dbGetQuery(pdResConn, "SELECT * FROM aQFeatures;"), silent=TRUE)

  cat("plotting _1.png\n")
  if (nrow(psms)<1) {
		png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_1.png", sep=""), width=1400, height=500)
		plot(0, bty="n", xaxt="n", yaxt="n", xlab="", ylab="", type="n")
		text(1, 0, "no PSMS checked", col="red", cex=3)
		dev.off()
		return(0)
	}

	# numericColumns <- c("X..Proteins", "X..Protein.Groups", "X.Score", "X.Cn", "Rank", "Search.Engine.Rank", "QuanResultID", "Precursor.Area", "q.Value", "PEP", "IonScore", "Exp.Value", "MissedCleavages", "Isolation.Interference....", "Ion.Inject.Time..ms.", "Charge", "m.z..Da.", "MH...Da.", "DeltaMassInPPM", "RT..min.", "First.Scan", "Last.Scan")
	numericColumns <- c("DeltaCn", "Rank", "SearchEngineRank", "MissedCleavages", "IonInjectTime", "Charge", "MassOverCharge", "Mass", "DeltaMassInPPM", "RetentionTime", "FirstScan", "LastScan")
	psms[,colnames(psms) %in% numericColumns] <- apply(psms[,colnames(psms) %in% numericColumns, drop=FALSE], 2, as.numeric)

	nSamples <- length(unique(psms$SpectrumFileName))
	#nPlots <- 15
	nPlots1 <- 11
	nPlots2 <- 9
	cexNames <- 2
	longestFnameLen <- max(nchar(as.character(unique(psms$SpectrumFileName))))
	if (longestFnameLen>55) {
		cexNames <- 110/longestFnameLen
	}
	
	runCols <- rainbow(length(unique(psms$SpectrumFileName)))
	
	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_1.png", sep=""), width=1400, height=nPlots1*(180+20*nSamples))
	par(mfrow=c(nPlots1,1))
	
	tr <- try({
  	if (checkCols(c("DeltaMassInPPM", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		boxplot(psms$DeltaMassInPPM ~ psms$SpectrumFileName, horizontal=TRUE, ylim=c(-10,10), xlab="delta mass [ppm]", xlim=c(nSamples+0.7,0.3), main="mass deviation", cex.axis=2, cex.lab=2, cex.main=2, cex=2, yaxt="n", ylab="")
  		axis(2, cex.axis=cexNames, labels=levels(psms$SpectrumFileName), at=1:length(levels(psms$SpectrumFileName)))
  		abline(v=0, lty=3)
  	}
  
  	if (checkCols(c("MissedCleavages", "Annotated.Sequence", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		barplot(rev(100*unlist(as.list(by(psms[,c("MissedCleavages", "Annotated.Sequence"), drop=FALSE], list(f=psms$SpectrumFileName), function(s) { mclPeps <- tapply(s$MissedCleavages, s$Annotated.Sequence, mean); mean(mclPeps>0, na.rm=TRUE) })))), horiz=TRUE, xlim=c(0,100), xlab="peptides with missed cleavage [%]", main="miscleaved peptides", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, xaxt="n")
  		axis(1, 0:10*10, 0:10*10, cex.axis=2)
  		barplot(rev(100*unlist(as.list(by(psms[,c("MissedCleavages", "Annotated.Sequence"), drop=FALSE], list(f=psms$SpectrumFileName), function(s) { mclPeps <- tapply(s$MissedCleavages, s$Annotated.Sequence, mean); mean(mclPeps>1, na.rm=TRUE) })))), horiz=TRUE, col="black", add=TRUE, yaxt="n", xaxt="n")
  		legend("topright", c("1 missed cleavage", "> 1"), fill=c("grey", "black"), cex=2)
  	}
  
  	if (checkCols(c("FirstScan", "SpectrumFileName"), colnames(spectrumInfo))) {
  		if (checkCols(c("FirstScan", "SpectrumFileName"), colnames(psms))) {
  		  idRate <- merge(x=as.matrix(by(psms$FirstScan, list(f=psms$SpectrumFileName), length)), y=as.matrix(by(spectrumInfo$FirstScan, list(f=spectrumInfo$SpectrumFileName), function(x) { length(unique(x)) })), by="row.names", all=TRUE)
  		  # correct for duplicated spectra with unknown charge state with the unique
  		  m <- "identified spectra [%]"
  		  if (nrow(psms)>(1.01*(nrow(unique(psms[,c("FirstScan", "SpectrumFileName")]))))) {
  		    # for bruker data:
  		    # many spectra with the same first scan -> multiple psms per scan -> id rate>100%
  		    # simply count msms spectrum info and divide by #psms
  		    idRate <- merge(x=as.matrix(table(psms$SpectrumFileName)), y=as.matrix(table(spectrumInfo$SpectrumFileName)), by="row.names")
  		    m <- "identified MS/MS Spectrum Info [%]"
  		  }
  			idRate[is.na(idRate[,2, drop=FALSE]),2] <- 0
  			rownames(idRate) <- idRate$Row.names
  			idRate <- idRate[,-which(colnames(idRate)=="Row.names"), drop=FALSE]
  			idRate <- data.frame(idRate, idr=idRate[,1]/idRate[,2],stringsAsFactors=FALSE)
  			if (mean(rownames(idRate) %in% sampleOrder$file)>0) {
  				idRate <- idRate[rev(sampleOrder$file),]
  			}
  			par(mar=c(5,75,7,2))
  			barplot(100*idRate[,"idr"], names=rownames(idRate), horiz=TRUE, xlim=c(0,100), xlab=m, main="id rate", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, xaxt="n")
  			axis(1, 0:10*10, 0:10*10, cex.axis=2)
  		}
  	}
  
  	if (checkCols(c("SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		barplot(rev(table(psms$SpectrumFileName)), horiz=TRUE, xlab="#PSMs", main="identified spectra", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, col=rev(runCols))
  	}
  	
  	if (checkCols(c("Charge", "SpectrumFileName"), colnames(spectrumInfo))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		tmp <- table(spectrumInfo[,c("Charge", "SpectrumFileName")])
  		legCex <- 2
  		if (length(unique(spectrumInfo$SpectrumFileName))<3) { legCex <- 1.5 }
  		if (length(unique(spectrumInfo$SpectrumFileName))<2) { legCex <- 1.2 }
  		barplot(tmp[,rev(1:ncol(tmp))], beside=TRUE, horiz=TRUE, xlab="# spectra", main="charge state distribution", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, legend.text=TRUE, args.legend=c(cex=legCex), xlim=c(0,1.1*max(tmp)), col=grey(1:nrow(tmp)/(nrow(tmp)+2)))
  	}
  
  	if (checkCols(c("MS2Errorppm", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		boxplot(psms$MS2Errorppm ~ psms$SpectrumFileName, horizontal=TRUE, ylim=c(0,max(30, max(psms$MS2Errorppm))), xlab="MS2 Error [ppm]", xlim=c(nSamples+0.7,0.3), main="MS2 Error", cex.axis=2, cex.lab=2, cex.main=2, cex=2, yaxt="n", ylab="")
  		axis(2, cex.axis=cexNames, labels=levels(psms$SpectrumFileName), at=1:length(levels(psms$SpectrumFileName)))
  	}
  	
  	if (checkCols(c("Modifications", "Annotated.Sequence", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		barplot(rev(100*unlist(as.list(by(psms[,c("Annotated.Sequence", "Modifications"), drop=FALSE], list(f=psms$SpectrumFileName), function(fPsms) { ms <- sum(unlist(lapply(gregexpr("[mM]", fPsms$Annotated.Sequence), function(x) { length(x[x>0]) }))); oxM <- sum(unlist(lapply(gregexpr("M\\d+\\(Oxidation\\)", fPsms$Modifications, perl=TRUE), function(x) { length(x[x>0]) }))); oxM/ms })))), horiz=TRUE, xlim=c(0,100), xlab="oxidised methionines [%] - PSM level", main="methionine oxidation", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, xaxt="n")
  		axis(1, 0:10*10, 0:10*10, cex.axis=2)
  	}
  
  	if (checkCols(c("Modifications", "Annotated.Sequence", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		barplot(rev(100*unlist(as.list(by(psms[,c("Annotated.Sequence", "Modifications"), drop=FALSE], list(f=psms$SpectrumFileName), function(fPsms) { nqs <- sum(unlist(lapply(gregexpr("[nNqQ]", fPsms$Annotated.Sequence), function(x) { length(x[x>0]) }))); deam <- sum(unlist(lapply(gregexpr("[NQ]\\d+\\(Deamidated\\)", fPsms$Modifications, perl=TRUE), function(x) { length(x[x>0]) }))); deam/nqs })))), horiz=TRUE, xlim=c(0,100), xlab="deamidated N/Q [%] - PSM level", main="deamidation", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, xaxt="n")
  		axis(1, 0:10*10, 0:10*10, cex.axis=2)
  	}
  	
  	# if (quanResNFoundMsg=="") {
  	#   d <- quanRes[,rev(quanCols),drop=FALSE] # !!! don't change column order -> names
  	#   par(mar=c(5,75,7,2))
  	#   barplot(apply(d>0, 2, sum, na.rm=TRUE), names=gsub("\\.raw$", "", rev(quanCols)), horiz=TRUE, xlim=c(0,nrow(quanRes)), xlab="# quantified features", main="quantified features", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
  	# }
  	# else {
  	#   plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	#   text(1, 0, quanResNFoundMsg, col="red", cex=2)
  	# }

  	if (quanResNFoundMsg=="") {
  	  if ("aQfs" %in% ls()) {
    	  par(mar=c(5,75,7,2))
      	aQconfs <- do.call("rbind", lapply(gsub("\\.raw$", "", sampleOrder$file), function(rf) { corrRF <- (rf==gsub("\\.raw$", "", aQfs$RawFile)); data.frame(rf=rf, unk=sum(corrRF), low=sum(aQfs$Confidence>0 & corrRF), med=sum(aQfs$Confidence>1 & corrRF), hi=sum(aQfs$Confidence>2 & corrRF), stringsAsFactors = FALSE) }))
      	rownames(aQconfs) <- aQconfs$rf
      	aQconfs <- as.matrix(t(aQconfs[,-1]))
      	aQconfs <- aQconfs[,rev(colnames(aQconfs))]
      	barplot(aQconfs[1,], horiz=TRUE, xlab="# features", main="apQuant feature confidence", cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2, col="grey")
      	barplot(aQconfs[2,], horiz=TRUE, add=TRUE, col="red", xaxt="n", yaxt="n")
      	barplot(aQconfs[3,], horiz=TRUE, add=TRUE, col="orange", xaxt="n", yaxt="n")
      	barplot(aQconfs[4,], horiz=TRUE, add=TRUE, col="green", xaxt="n", yaxt="n")
  	  }
  	  else {
  	    plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	    text(1, 0, "no apQuant features available", col="red", cex=2)
  	  }
  	}
  	else {
  	  plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	  text(1, 0, quanResNFoundMsg, col="red", cex=2)
  	}
	  
	  if (quanResNFoundMsg=="") {
	    d <- quanRes[,rev(quanCols),drop=FALSE]
	    d[d<=0] <- NA
	    colnames(d) <- gsub("\\.raw$", "", colnames(d))
	    boxplot(log10(d), horizontal=TRUE, main="raw intensities", xlab="intensity", cex.lab=2, cex.main=2, cex=2, cex.axis=cexNames, xaxt="n")
	    axis(1, at=log10(rep(1:9, 41)*10^(rep(-20:20, each=9))), labels = rep("", 41*9), cex.axis=2)
	    axis(1, -21:20, 10^(-21:20), cex.axis=2)
	  }
	  else {
	    plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
	    text(1, 0, quanResNFoundMsg, col="red", cex=2)
	  }
  	
  	if (quanResNFoundMsg=="") {
  	  if (deInst) {
  	    d <- quanRes[,quanCols,drop=FALSE]
  	    if (ncol(d)>1) {
  	      d <- log10(d)
  	      d[abs(d)>9e99] <- NA
  	      # colnames(d) <- gsub("File", "", gsub("raw$", "", unlist(lapply(colnames(d), function(n) { substr(n, nchar(n)-50, nchar(n)) }))))
  	      colnames(d) <- gsub("File", "", gsub("\\.raw$", "", colnames(d)))
  	      par(mar=c(3,37,4,1))
  	      s <- par()[["cex"]]
  	      par(cex=0.7*cexNames)
  	      dt <- d[,apply(d, 2, function(x) { sum(x>0, na.rm=TRUE) })>50,drop=FALSE]
  	      if (ncol(dt)>1) {
  	        cm <- cor(dt, use="pairwise.complete.obs")
  	        cm[is.na(cm)] <- 0
  	        dend <- as.dendrogram(hclust(as.dist(1-cm)))
  	        plot_horiz.dendrogram(dend, side=TRUE)
  	        par(cex=s)
  	      }
  	      else {
  	        plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	        text(1, 0, "dendrogram requires multiple samples\nwith >50 features quantified", col="red", cex=2)
  	      }
  	    }
  	    else {
  	      plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	      text(1, 0, "dendrogram requires multiple samples", col="red", cex=2)
  	    }
  	  }
  	  else {
  	    plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	    text(1, 0, "could not load package \"dendextend\"", col="red", cex=2)
  	  }
  	}
  	else {
  	  plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  	  text(1, 0, quanResNFoundMsg, col="red", cex=2)
  	}

  	#	plot here
	})	
	if (class(tr)=="try-error") {
	  cat("something crashed in plot _1\n")
	}
	dev.off()
	
	
# second plot which does not scale with number of raw files	
	cat("plotting _2.png\n")
	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_2.png", sep=""), width=1400, height=nPlots2*500)
	par(mfrow=c(nPlots2,1))
	tr <- try({
  	if (checkCols(c("Modifications", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		ms <- data.frame(modi="n")
  		rfs <- as.character(unique(psms$SpectrumFileName))
  		lapply(rfs, function(rf) { 
  		  # remove methionine oxidation
  		  noMoxModis <- lapply(strsplit(psms$Modifications[psms$SpectrumFileName==rf], ";"), function(ms) { ms[!grepl("M\\d+\\(Oxidation\\)", ms)] })
  		  msf <- as.data.frame(table(gsub("\\)", "", gsub("^[^\\(]*\\(", "", unlist(noMoxModis)))), stringsAsFactors=FALSE)
  		  msf <- rbind(data.frame(Var1=c("n"), Freq=0, stringsAsFactors=FALSE), msf)
  		  colnames(msf) <- c("modi", rf)
  		  ms <<- merge(ms, msf, all=TRUE, by="modi")
  	  NULL })
  		rownames(ms) <- ms$modi
  		ms <- ms[(!(ms$modi=="n")),(!(colnames(ms)=="modi")),drop=FALSE]
  		ms[is.na(ms)] <- 0
  		ms <- ms[order(apply(ms, 1, max)),rev(1:ncol(ms)),drop=FALSE]
  		ms <- ms[!grepl("^TMT", rownames(ms)),,drop=FALSE]
  		ms <- ms[(!(rownames(ms) %in% c("Methylthio", "Carbamidomethyl", "Deamidated"))),,drop=FALSE]
      if (nrow(ms)>=10) {
        par(mar=c(5,7,7,2))
        shortLabLen <- round(100/nrow(ms))
      }
      else {
        par(mar=c(5,75,7,2))
        shortLabLen <- round(52/nrow(ms))
      }
  
      orns <- rownames(ms)
      rns <- substr(gsub("^Label:", "", rownames(ms)), 1, shortLabLen)
      trns <- table(rns)
      drns <- rns %in% names(trns[trns>1])
      dupliNames <- rownames(ms)[drns]
      rns[drns] <- substr(dupliNames, nchar(dupliNames)+1-shortLabLen, nchar(dupliNames))
      trns <- table(rns)
      drns <- rns %in% names(trns[trns>1])
      dupliNames <- rownames(ms)[drns]
      rns[drns] <- substr(dupliNames, nchar(dupliNames)+1-shortLabLen+2, nchar(dupliNames))
      rns[drns] <- paste(rns[drns], "_", which(drns))
      rownames(ms) <- rns
      if (nrow(ms)>0) {
  		  ms <- ms[,levels(psms$SpectrumFileName)[levels(psms$SpectrumFileName) %in% colnames(ms)],drop=FALSE] # bring runs in correct order to match with run colors (runCols)
  		  barplot(as.matrix(t(ms)), beside=TRUE, col=runCols[levels(psms$SpectrumFileName) %in% colnames(ms)], main="other modifications",	cex.axis=2, cex.names=cexNames, cex.main=2, cex.lab=2)
  		  legend("topleft", paste(1:nrow(ms), " - ", rns, " - ", orns, sep=""), cex=2)
      }
  		else {
  			plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  			text(1, 0, "no modifications found", col="red", cex=2)
  		}
  	}
  
  	if (checkCols(c("AmandaScore", "SpectrumFileName"), colnames(psms))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		scoreDist <- tapply(psms$AmandaScore, psms$SpectrumFileName, density, bw=5)
  		plot(0, type="n", xlim=range(psms$AmandaScore), ylim=c(0, max(unlist(lapply(scoreDist, function(d) { d[["y"]]*d[["n"]] })))), xlab="Amanda Score", ylab="", yaxt="n", main="score distribution", cex.axis=2, cex.main=2, cex.lab=2)
  		unlist(lapply(1:length(scoreDist), function(sdIx) { d <- scoreDist[[sdIx]]; lines(d[["x"]], d[["y"]]*d[["n"]], col=runCols[sdIx]); NULL }))
  	}
  	
    if (checkCols(c("AmandaScore"), colnames(psms))) {
      if (checkCols(c("AmandaScore"), colnames(dPsms))) {
        bs <- min(c(0,round(min(c(psms$AmandaScore, dPsms$AmandaScore)), 0)-1)):max(c(0,round(max(c(psms$AmandaScore, dPsms$AmandaScore)), 0)+1))
        xmax <- round(max(c(quantile(c(psms$AmandaScore), 0.99), quantile(c(dPsms$AmandaScore), 0.99))), 0)
        ymax <- max(table(cut(psms$AmandaScore, breaks=bs)), table(cut(dPsms$AmandaScore, breaks=bs)))
        hist(dPsms$AmandaScore, breaks=bs, col="#FF000080", border=NA, main="Target/Decoy Score Distribution", xlab="Amanda Score", ylim=c(0,ymax), xlim=c(0,xmax), cex.axis=2, cex.main=2, cex.lab=2)
        hist(psms$AmandaScore[psms$AmandaScore<max(bs)], breaks=bs, col="#00FF0080", border=NA, add=TRUE)
      }
    }
  
  	if (checkCols(c("RetentionTime", "SpectrumFileName"), colnames(spectrumInfo))) {
  		if (checkCols(c("RetentionTime", "SpectrumFileName"), colnames(psms))) {
  			groupMins <- 2
  			psmsPmin <- tapply(psms$RetentionTime, psms$SpectrumFileName, function(rts) {
  				ret <- as.data.frame(table(round(rts/groupMins, 0))/groupMins, stringsAsFactors=FALSE)
  				colnames(ret) <- c("t", "nPsms")
  				ret$t <- as.numeric(ret$t)
  				ret
  			})
  			par(mar=c(5,75,7,2))
  			plot(0, type="n", xlim=range(spectrumInfo$RetentionTime), ylim=c(0, max(unlist(lapply(psmsPmin, function(ppm) { max(ppm[,"nPsms", drop=FALSE]) })))), xlab="retention time [min]", ylab="", main="id speed", cex.axis=2, cex.main=2, cex.lab=2)
  			# mtext("PSMs/min", 2, 4, cex=2)
  			title(ylab="PSMs/min", cex.lab=2, line=5)
  			unlist(lapply(1:length(psmsPmin), function(ppmIx) { ppm <- psmsPmin[[ppmIx]]; lines(groupMins*t(ppm[,"t", drop=FALSE]), t(ppm[,"nPsms", drop=FALSE]), col=runCols[ppmIx]); NULL }))
  		}
  	}
  
  	if (checkCols(c("OriginalPrecursorMass", "SpectrumFileName"), colnames(spectrumInfo))) {
  		par(las=1)
  		par(mar=c(5,75,7,2))
  		precDist <- tapply(spectrumInfo$OriginalPrecursorMass, spectrumInfo$SpectrumFileName, density, bw=5)
  		plot(0, type="n", xlim=range(spectrumInfo$OriginalPrecursorMass), ylim=c(0, max(unlist(lapply(precDist, function(d) { d[["y"]]*d[["n"]] })))), xlab="m/z [Th]", ylab="", yaxt="n", main="precursor distribution", cex.axis=2, cex.main=2, cex.lab=2)
  		unlist(lapply(1:length(precDist), function(pdIx) { pd <- precDist[[pdIx]]; lines(pd[["x"]], pd[["y"]]*pd[["n"]], col=runCols[pdIx]); NULL }))
  	}
  
  	if (checkCols(c("SearchSpace", "SpectrumFileName"), colnames(psms))) {
  		searchSpace <- tapply(psms$SearchSpace, psms$SpectrumFileName, sort)
  		par(mar=c(5,75,7,2))
  		plot(0, type="n", xlim=c(0,max(unlist(lapply(searchSpace, length)))), ylim=c(0,max(unlist(searchSpace, max))), xlab="PSMs", ylab="", main="search space", cex.axis=2, cex.main=2, cex.lab=2)
  		# mtext("search space", 2, 4, cex=2)
  		title(ylab="search space", cex.lab=2, line=5)
  		unlist(lapply(1:length(searchSpace), function(ix) { lines(searchSpace[[ix]], col=runCols[ix]) }))
  	}
  	
  	distFerrorPlot <- function (msg, n=2) {
  	  lapply(1:n, function(x) {
    	  plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
    	  text(1, 0, paste("plot not available:\n", msg, sep=""), col="red", cex=2)
  	  })
  	}
  	if (class(aQfRet)=="try-error") {
  	  distFerrorPlot("could not find apQuant features", 3)
	  }
  	else {
      try(aQscoreNames <- dbGetQuery(pdResConn, "SELECT Name FROM DataDistributionBoxes WHERE DataDistributionMapID=(SELECT SpecialValueTypeID FROM DataTypesColumns WHERE DBColumnName='apQuantScores' AND SpecialValueType='DataDistribution' AND DataTypeID=(SELECT DataTypeID FROM DataTypes WHERE TableName='aQFeatures')) ORDER BY Position;")[,1])
      # remove samples not checked in (/passed on) from MS2Go
      # also does reordering already
  
      aQfs$RawFile <- gsub(".raw", "", aQfs$RawFile, fixed=TRUE)
      aQfs$RawFile <- as.factor(aQfs$RawFile)
      if (mean(aQfs$RawFile %in% sampleOrder$file)>0) {
        aQfs$RawFile <- factor(aQfs$RawFile, levels(aQfs$RawFile)[unlist(lapply(as.character(sampleOrder$file), function(l) { which(levels(aQfs$RawFile)==l) }))])
      }
      aQfs <- aQfs[!is.na(aQfs$RawFile),]
  
      if (!("distF" %in% aQscoreNames)) {
        distFerrorPlot("could not find apQuant feature distF", 2)
      }
      else {
        distFs <- unlist(lapply(aQfs[,"apQuantScores"], function(aQscores) { BytesToDouble((aQscores)[1:8+(which(aQscoreNames=="distF")-1)*9]) }))
        if (length(distFs)==nrow(aQfs)) {
          aQfs <- data.frame(aQfs[,!(colnames(aQfs) %in% c("Intensities", "Times", "ShowSpectrum"))], distF=distFs, stringsAsFactors=FALSE)
          if (sum(aQfs$Confidence>2)>0) {
            aQfs1 <- aQfs[aQfs$Confidence>1,,drop=FALSE]
            bins <- c(0, 10^((0:60)/3))
            binCenters <- apply(data.frame(bins[1:(length(bins)-1)], bins[2:length(bins)]), 1, mean)
            medDistF <- tapply(aQfs1$distF, list(rf=aQfs1$RawFile, ab=cut(aQfs1$Area, bins)), function(x) { x <- x[!is.na(x)]; ret <- NA; if (length(x)>50) { ret <- median(x) }; ret })
            ym <- max(c(20, max(c(0, medDistF), na.rm=TRUE)), na.rm=TRUE)
            plot(aQfs1[aQfs1$Confidence>2, c("Area", "distF")], log="x", pch=16, col="#00000010", ylim=c(0, ym), xlim=range(aQfs1$Area), cex.axis=2, cex.main=2, cex.lab=2, main="noisiness over intensity (high & med conf)", xlab="apQuant Area")
            polygon(c(1e20, 1e9, 1e8, 1e8, 1e20, 1e20), c(5,5,8,100,100,5), col="#FF000020", fillOddEven=TRUE, lty=0)
            lapply(0:5, function(h) { abline(h=5*h, lty=3)} )
            lapply(1:nrow(medDistF), function(mdfIx) { lines(binCenters, medDistF[mdfIx,], col=runCols[which(gsub("\\.raw", "", rownames(medDistF))[mdfIx]==levels(psms$SpectrumFileName))], lwd=2) })
  
            xl <- range(c(0, aQfs$PeakApex[aQfs$PeakApex>=0]), na.rm=TRUE)
            aQfs2 <- aQfs[aQfs$Confidence>2,,drop=FALSE]
            medDistF <- tapply(aQfs2$distF, list(rf=aQfs2$RawFile, rt=5*round(aQfs2$PeakApex/5, 0)), function(x) { x <- x[!is.na(x)]; ret <- NA; if (length(x)>50) { ret <- median(x) }; ret })
            ym <- max(c(20, max(c(0, medDistF), na.rm=TRUE)), na.rm=TRUE)
            plot(aQfs2[, c("PeakApex", "distF")], pch=16, col="#00000005", ylim=c(0, ym), xlim=xl, cex.axis=2, cex.main=2, cex.lab=2, main="noisiness over retention time (high conf)", xlab="retention time [min]")
            rect(-100,8,1000,100,col="#FF000020", border=NA)
            lapply(0:5, function(h) { abline(h=5*h, lty=3)} )
            lapply(1:nrow(medDistF), function(mdfIx) { lines(as.numeric(colnames(medDistF)), medDistF[mdfIx,], col=runCols[which(gsub("\\.raw", "", rownames(medDistF))[mdfIx]==levels(psms$SpectrumFileName))], lwd=2) })
          }
          else {
            distFerrorPlot("could not find high confidence apQuant features", 2)
          }
        }
        else {
          distFerrorPlot("distF does not fit", 2)
        }
      }

      cat("querying for apQuant decoy features\n")
      r <- try(aQdfs <- dbGetQuery(pdResConn, "SELECT * FROM aQDecoyFeatures;"), silent=TRUE)
      if (class(r)=="try-error") { 
        distFerrorPlot("could not find apQuant decoy features", 1)
      }
      else {
        bs <- 25*range(c(aQfs$Score, aQdfs$Score), na.rm=TRUE)
        bs <- round(bs, 0)+c(-1,1)
        bs <- (bs[1]:bs[2])/25
        if (sum(aQfs$Confidence>2)>0) {
          highTh <- min(aQfs$Score[aQfs$Confidence>2])
          bs[which.min(abs(bs-highTh))] <- highTh
        }
        if (sum(aQfs$Confidence>1)>0) {
          medTh <- min(aQfs$Score[aQfs$Confidence>1])
          bs[which.min(abs(bs-medTh))] <- medTh
        }
        suppressWarnings({
          hist(aQfs$Score, col="#00000000", breaks=bs, border=NA, main="Target/Decoy apQuant Score Distribution", xlab="apQuant Score", cex.axis=2, cex.main=2, cex.lab=2, freq=TRUE)
          hist(aQfs$Score[aQfs$Confidence==3], col="#00FF0080", breaks=bs, border=NA, add=TRUE, freq=TRUE)
          hist(aQfs$Score[aQfs$Confidence==2], col="#FFFF0080", breaks=bs, border=NA, add=TRUE, freq=TRUE)
          hist(aQfs$Score[aQfs$Confidence==1], col="#FF000080", breaks=bs, border=NA, add=TRUE, freq=TRUE)
          hist(aQfs$Score[aQfs$Confidence<1], col="#A52A2A80", breaks=bs, border=NA, add=TRUE, freq=TRUE)
          hist(aQdfs$Score, breaks=bs, col="#00000080", border=NA, add=TRUE, freq=TRUE)
        })
      }
    }

  
  # # trying other approach for dendrogram (distance based on log intensities, not on correlation)
  # # made results worse on: 20190529_QExHFX1_RSLC1_Dagdas_Dagdas_GMI_onbead_ATG8a_peptide_40perc_sample_11-18_Set2_mpoly_Step2.pdResult
  	# if (quanResNFoundMsg=="") {
  		# if (deInst) {
  			# d <- quanRes[,quanCols,drop=FALSE]
  			# if (ncol(d)>1) {
  				# d <- log10(d)
  				# d[abs(d)>9e99] <- NA
  				# ## only top abundant peptides
  				# #d <- d[rev(order(apply(d, 1, sum, na.rm=TRUE)))[1:round(nrow(d)/2, 0)],]
  				# ## impute missing peptides
  				# #d[is.na(d)] <- quantile(d, 0.05, na.rm=TRUE)
  				
  				# colnames(d) <- gsub("File", "", gsub("raw$", "", colnames(d)))
  				# par(mar=c(3,37,4,1))
  				# s <- par()[["cex"]]
  				# par(cex=0.7*cexNames)
  				# plot_horiz.dendrogram(as.dendrogram(hclust(dist(t(d)))), side=TRUE)
  				# par(cex=s)
  			# }
  			# else {
  				# plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  				# text(1, 0, "dendrogram requires multiple samples", col="red", cex=2)
  			# }
  		# }
  		# else {
  			# plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  			# text(1, 0, "could not load package \"dendextend\"", col="red", cex=2)
  		# }
  	# }
  	# else {
  		# plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  		# text(1, 0, quanResNFoundMsg, col="red", cex=2)
  	# }
	})  
	if (class(tr)=="try-error") {
	  cat("something crashed in plot _2\n")
	}
	dev.off()
	
	cat("plotting PCA\n")
	png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_pca.png", sep=""), width=1400, height=900)
	plot(0, bty="n", xaxt="n", yaxt="n", xlab="", ylab="", type="n")
  tr <- try({
  	if (quanResNFoundMsg=="") {
  #d was defined nowhere 	
      d2 <- d[,apply(!is.na(d), 2, sum)>500,drop=FALSE]
  	  if (ncol(d2)>1) {
    		if (sum(apply(is.na(d2), 1, sum)==0)>ncol(d2)) {
    		  dev.off()
    		  # make a variable height plot with legend on top
    		  png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_pca.png", sep=""), width=1400, height=900+30*ncol(d2))
  				pcs <- princomp(~ ., data=data.frame(d2, stringsAsFactors = FALSE), cor=TRUE)
  				pcls <- pcs$loadings[,1:2]
  				yr <- range(pcls[,2])
  				if (sum(levels(psms$SpectrumFileName) %in% colnames(d2))>0) {
  				  # color by runs (LFQ)
  				  pcaCols <- runCols[levels(psms$SpectrumFileName) %in% colnames(d2)]
  				}
  				else {
  				  # TMT: separate coloring by channel for TMT
  				  pcaCols <- rainbow(ncol(d2))
  				}
  				plot(pcls, xlim=c(min(pcls[,1]), max(pcls[,1])+(0.5*(max(pcls[,1])-min(pcls[,1])))), col=pcaCols, pch=1:nrow(pcls), cex=1.7, cex.axis=1.7, cex.lab=1.7, ylim=c(yr[1], yr[2]+(ncol(d2)/27)*(yr[2]-yr[1])))
  				unlist(lapply(1:nrow(pcls), function(ix) { text(pcls[ix,1], pcls[ix,2], ix, pos=4, cex=1.7) }))
  				legend("topright", paste(1:nrow(pcls), substr(rownames(pcls), pmax(1,nchar(rownames(pcls))-50), nchar(rownames(pcls))), sep=": "), pch=1:nrow(pcls), col=pcaCols, cex=1.7, bg=NA)
    		}
    		else {
    			text(1, 0, "not enough quantitative features in common to do PCA", col="red", cex=2)
    		}
  	  } else {
  	    text(1, 0, "PCA requires multiple samples\nwith >500 features quantified", col="red", cex=2)
  	  }
  	}
  	else {
  		text(1, 0, quanResNFoundMsg, col="red", cex=2)
  	}
  })
  if (class(tr)=="try-error") {
    cat("something crashed in the pca plot\n")
  }
  dev.off()

# !!! fraction of missing quan values per file on protein/peptide level !!!
# make heatmap for other modis
## include ms2 mass deviation if available
# fraction of PSMs identified by first/second search and clustering ~ ID rate
## cumulative search space curve (all files in one plot)
## precursor m/z distributaion (all files in one plot)
## quan value correlation matrix to see replicates (color and scatter plot on triangles)
# see Ottos suggestions (mail/youtrack)
# see plots from Zuerich (pdf in this folder)

# correlation of quan results between runs
# advantage:
# - no decoding of doubles required, as in PJ protein areas
# - runs are not combined into samples
  cat("plotting _corr.png\n")
  png(paste(gsub(".png", "", pngFileName, fixed=TRUE), "_corr.png", sep=""), width=1700, height=1700)
	plot(0, bty="n", xaxt="n", yaxt="n", xlab="", ylab="", type="n")
	tr <- try({
  	if (quanResNFoundMsg=="") {
  		d <- quanRes[,quanCols,drop=FALSE]
  		if (ncol(d)>1) {
  			# remove samples without quantified peptides
  			d <- d[,apply(d, 2, function(x) { sum(x>0, na.rm=TRUE) })>50,drop=FALSE]
  			if (ncol(d)>1) {
  			  # colnames(d) <- gsub("^.{70}", "", quanCols)
    			# plot(log10(d))
    			# samples have the same order from top to bottom
    			suffixLen <- 43
    			if (ncol(d)>6) { suffixLen <- 35 }
    			if (ncol(d)>10) { suffixLen <- 23 }
    			d <- log10(d)
    			d[abs(d)>9e99] <- NA
    			colnames(d) <- gsub("\\.raw$", "", unlist(lapply(colnames(d), function(n) { substr(n, nchar(n)-suffixLen, nchar(n)) })))
    			colnames(d) <- gsub("File", "", gsub("raw$", "", colnames(d)))
    			pairs.panels(d, hist.col="white", ellipses=FALSE, rug=FALSE, smooth=FALSE)
  			}
  			else {
  			  text(1, 0, "correlation plot requires multiple samples\nwith >50 features quantified", col="red", cex=2)
  			}
  		} 
  		else {
  #			plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  			text(1, 0, "correlation plot requires multiple samples", col="red", cex=2)
  		}
  	}
  	else {
  #		plot(0, type="n", xaxt="n", yaxt="n", xlab="", ylab="")
  		text(1, 0, quanResNFoundMsg, col="red", cex=2)
  	}
	})
	if (class(tr)=="try-error") {
	  cat("something crashed in the corr plot\n")
	}
	dev.off()

	
	dbDisconnect(pdResConn)
	dbDisconnect(pdResViewConn)
	NULL
}
